<?php
namespace VM\AdminBundle\Command;

use Doctrine\Bundle\DoctrineBundle\Registry;
use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\AdminBundle\Services\ApiGetter;
use VM\ApiBundle\Entity\CompanyBankServiceOption;
use VM\ApiBundle\Entity\CompanyOfferReport;
use VM\ApiBundle\Entity\AccountChange;
use VM\ApiBundle\Entity\CompanyReport;
use VM\ApiBundle\Entity\GroupRoundReportCode;

class ChangeReportCodeStructureCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('change:report:code:structure')
            ->setDescription('Change structure of auth-codes in round reports - codes as separate table')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $EntityManager = $this->getDoctrine();

        $this->runNativeSQLQuery("
            CREATE TABLE group_round_reports_codes
            (
                id INT AUTO_INCREMENT NOT NULL,
                round_id INT NOT NULL,
                group_id INT NOT NULL,
                code VARCHAR(6) NOT NULL,
                extended TINYINT(1) NOT NULL,
                version INT NOT NULL,
                UNIQUE INDEX UNIQ_6EEF736E77153098 (code),
                INDEX IDX_6EEF736EA6005CA0 (round_id),
                INDEX IDX_6EEF736EFE54D947 (group_id),
                PRIMARY KEY(id)
            ) DEFAULT CHARACTER SET utf8
            COLLATE utf8_unicode_ci ENGINE = InnoDB;
        ", $output);

        $this->runNativeSQLQuery("
            INSERT INTO group_round_reports_codes(round_id, group_id, code, extended, version)
            SELECT
            cr.round_id AS round_id, c.user_groups_id AS group_id, cr.`code` AS `code`, cr.`extended` AS `extended`, cr.version AS version
            FROM
            company_reports AS cr
            LEFT JOIN company AS c ON c.id = cr.company_id
        ", $output);

        $this->runNativeSQLQuery("
            ALTER TABLE group_round_reports_codes
            ADD CONSTRAINT FK_6EEF736EA6005CA0
            FOREIGN KEY (round_id) REFERENCES rounds (id);
        ", $output);

        $this->runNativeSQLQuery("
            ALTER TABLE group_round_reports_codes
            ADD CONSTRAINT FK_6EEF736EFE54D947
            FOREIGN KEY (group_id) REFERENCES users_groups (id)
        ", $output);

        $this->runNativeSQLQuery("
            ALTER TABLE company_reports
            ADD code_id INT;
        ", $output);

        $this->runNativeSQLQuery("
            ALTER TABLE company_reports
            ADD CONSTRAINT FK_D14DBD9227DAFE17
            FOREIGN KEY (code_id) REFERENCES group_round_reports_codes (id);
        ", $output);

        $this->runNativeSQLQuery("
            UPDATE company_reports AS cr
            LEFT JOIN group_round_reports_codes  AS grrc ON cr.round_id = grrc.round_id
            LEFT JOIN company AS c ON c.id = cr.company_id
            SET cr.code_id = grrc.id
            WHERE
            grrc.group_id = (SELECT user_groups_id FROM company WHERE company.id = cr.company_id) AND grrc.round_id = cr.round_id AND grrc.`extended` = cr.`extended`;
        ", $output);

        $this->runNativeSQLQuery("
            CREATE UNIQUE INDEX UNIQ_D14DBD9227DAFE17 ON
            company_reports (code_id);
        ", $output);

        $this->runNativeSQLQuery("ALTER TABLE company_reports DROP code", $output);

        $this->runNativeSQLQuery("
            ALTER TABLE company_reports CHANGE code_id code_id INT NOT NULL;
        ", $output);

        $output->writeln("Koniec.");
    }

    protected function randomKey()
    {
        $key = '';
        for($i = 0; $i < 2; $i++)
            $key = $key.mt_rand(10000000, 99999999);
        return $key;
    }


    /**
     * @return EntityManager
     */
    protected function getDoctrine()
    {
        return $this->getContainer()->get('doctrine.orm.default_entity_manager');
    }

    protected function runNativeSQLQuery($query, OutputInterface $output)
    {
        try
        {
            $stmt = $this->getDoctrine()
                ->getConnection()
                ->prepare($query);
            $stmt->execute();
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad przygotowujacych SQLi: ".$exception->getMessage());
        }
    }

    protected function runNativeSQLQueryAndGetResult($query, OutputInterface $output)
    {
        try
        {
            return $this->getContainer()->get('database_connection')->fetchAll($query);
        }
        catch(\Exception $exception)
        {
            $output->writeln("Blad wczytywania danych przez native SQL query: ".$exception->getMessage());
        }
    }
}